// npm package: datatables.net-bs5
// github link: https://github.com/DataTables/Dist-DataTables-Bootstrap5

'use strict';

(function () {

  $('#dataTableExample').DataTable({
    layout: {
      topEnd: {
        search: {
          placeholder: 'Suchen'
        }
      }
    },
    "aLengthMenu": [
      [5, 10, 30, 50, -1],
      [5, 10, 30, 50, "All"]
    ],
    "iDisplayLength": 10,
    "language": {
      search: ""
    },
    paginationType: 'simple_numbers'
  });

  $('#dataTableAuditLogs').DataTable({
    "order": [[5, "desc"]],
    stateSave: true,
    layout: {
      topEnd: {
        search: {
          placeholder: 'Suchen'
        }
      }
    },
    "aLengthMenu": [
      [30, 50, 100, -1],
      [30, 50, 100, "Alle"]
    ],
    "iDisplayLength": 30,
    "language": {
      "search": "",
      "sEmptyTable": "Keine Daten in der Tabelle vorhanden",
      "sInfo": "_START_ bis _END_ von _TOTAL_ Einträgen",
      "sInfoEmpty": "Keine Einträge vorhanden",
      "sInfoFiltered": "(gefiltert von _MAX_ Einträgen)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ Einträge anzeigen",
      "sLoadingRecords": "Wird geladen...",
      "sProcessing": "Bitte warten...",
      "sSearch": "Suchen",
      "sZeroRecords": "Keine Einträge vorhanden."
    },
    paginationType: 'simple_numbers'
  });

  $('#dataTableBookingHistory').DataTable({
    "order": [[5, "desc"]],
    stateSave: true,
    layout: {
      topEnd: {
        search: {
          placeholder: 'Suchen'
        }
      }
    },
    "aLengthMenu": [
      [30, 50, 100, -1],
      [30, 50, 100, "Alle"]
    ],
    "iDisplayLength": 30,
    "language": {
      "search": "",
      "sEmptyTable": "Keine Daten in der Tabelle vorhanden",
      "sInfo": "_START_ bis _END_ von _TOTAL_ Einträgen",
      "sInfoEmpty": "Keine Einträge vorhanden",
      "sInfoFiltered": "(gefiltert von _MAX_ Einträgen)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ Einträge anzeigen",
      "sLoadingRecords": "Wird geladen...",
      "sProcessing": "Bitte warten...",
      "sSearch": "Suchen",
      "sZeroRecords": "Keine Einträge vorhanden."
    },
    paginationType: 'simple_numbers'
  });

  $('#dTableIdentitiesMilitary').DataTable({
    stateSave: true,
    autoWidth: false, // Deaktiviert automatische Breitenanpassung für die gesamte Tabelle
    columnDefs: [
      {
        targets: -1, // Die Spalte, die angepasst werden soll (Index beginnt bei 0)
        width: '1px', // Minimale Breite (kann dynamisch angepasst werden)
        createdCell: function (td, cellData) {
          td.style.whiteSpace = 'nowrap'; // Verhindert Zeilenumbrüche
        }
      },
      {
        targets: -1, // Letzte Spalte
        orderable: false // Sortierbarkeit deaktivieren
      }
    ],
    order: [[0, 'asc']],
    layout: {
      topEnd: {
        search: {
          placeholder: 'Suchen'
        }
      }
    },
    "aLengthMenu": [
      [30, 50, 100, -1],
      [30, 50, 100, "Alle"]
    ],
    "iDisplayLength": 30,
    "language": {
      "search": "",
      "sEmptyTable": "Keine Soldaten vorhanden",
      "sInfo": "_START_ bis _END_ von _TOTAL_ Soldaten",
      "sInfoEmpty": "Keine Soldaten vorhanden",
      "sInfoFiltered": "(gefiltert von _MAX_ Soldaten)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ Einträge anzeigen",
      "sLoadingRecords": "Wird geladen...",
      "sProcessing": "Bitte warten...",
      "sSearch": "Suchen",
      "sZeroRecords": "Keine Soldaten vorhanden."
    },
    paginationType: 'simple_numbers'
  });

  $('#dTableIdentitiesCivil').DataTable({
    order: [[0, 'asc']],
    stateSave: true,
    autoWidth: false, // Deaktiviert automatische Breitenanpassung für die gesamte Tabelle
    columnDefs: [
      {
        targets: -1, // Die Spalte, die angepasst werden soll (Index beginnt bei 0)
        width: '1px', // Minimale Breite (kann dynamisch angepasst werden)
        createdCell: function (td, cellData) {
          td.style.whiteSpace = 'nowrap'; // Verhindert Zeilenumbrüche
        }
      },
      {
        targets: -1, // Letzte Spalte
        orderable: false // Sortierbarkeit deaktivieren
      }
    ],
    layout: {
      topEnd: {
        search: {
          placeholder: 'Suchen'
        }
      }
    },
    "aLengthMenu": [
      [30, 50, 100, -1],
      [30, 50, 100, "Alle"]
    ],
    "iDisplayLength": 30,
    "language": {
      "search": "",
      "sEmptyTable": "Keine Zivilisten vorhanden",
      "sInfo": "_START_ bis _END_ von _TOTAL_ Zivilisten",
      "sInfoEmpty": "Keine Zivilisten vorhanden",
      "sInfoFiltered": "(gefiltert von _MAX_ Zivilisten)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ Einträge anzeigen",
      "sLoadingRecords": "Wird geladen...",
      "sProcessing": "Bitte warten...",
      "sSearch": "Suchen",
      "sZeroRecords": "Keine Zivilisten vorhanden."
    },
    paginationType: 'simple_numbers'
  });


  $('#dTableIdentitiesGuest').DataTable({
    order: [[0, 'asc']],
    stateSave: true,
    autoWidth: false, // Deaktiviert automatische Breitenanpassung für die gesamte Tabelle
    columnDefs: [
      {
        targets: -1, // Die Spalte, die angepasst werden soll (Index beginnt bei 0)
        width: '1px', // Minimale Breite (kann dynamisch angepasst werden)
        createdCell: function (td, cellData) {
          td.style.whiteSpace = 'nowrap'; // Verhindert Zeilenumbrüche
        }
      },
      {
        targets: -1, // Letzte Spalte
        orderable: false // Sortierbarkeit deaktivieren
      }
    ],
    layout: {
      topEnd: {
        search: {
          placeholder: 'Suchen'
        }
      }
    },
    "aLengthMenu": [
      [30, 50, 100, -1],
      [30, 50, 100, "Alle"]
    ],
    "iDisplayLength": 30,
    "language": {
      "search": "",
      "sEmptyTable": "Keine Gäste vorhanden",
      "sInfo": "_START_ bis _END_ von _TOTAL_ Gäste",
      "sInfoEmpty": "Keine Gäste vorhanden",
      "sInfoFiltered": "(gefiltert von _MAX_ Gäste)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ Einträge anzeigen",
      "sLoadingRecords": "Wird geladen...",
      "sProcessing": "Bitte warten...",
      "sSearch": "Suchen",
      "sZeroRecords": "Keine Gäste vorhanden."
    },
    paginationType: 'simple_numbers'
  });

  $('#dTableIdentitiesLocal').DataTable({
    order: [[0, 'asc']],
    stateSave: true,
    autoWidth: false, // Deaktiviert automatische Breitenanpassung für die gesamte Tabelle
    columnDefs: [
      {
        targets: -1, // Die Spalte, die angepasst werden soll (Index beginnt bei 0)
        width: '1px', // Minimale Breite (kann dynamisch angepasst werden)
        createdCell: function (td, cellData) {
          td.style.whiteSpace = 'nowrap'; // Verhindert Zeilenumbrüche
        }
      },
      {
        targets: -1, // Letzte Spalte
        orderable: false // Sortierbarkeit deaktivieren
      }
    ],
    layout: {
      topEnd: [
        {
          div: {
            className: 'layout-end',
            html: `
                        <a href="/identities/authorized-identities" class="btn btn-sm btn-primary btn-icon-text me-2">
                            <i class="btn-icon-prepend mdi mdi-eye"></i>
                            Bedieneransicht
                        </a>
                        <a href="/identities/blacklist" class="btn btn-sm btn-danger btn-icon-text" data-bs-toggle="tooltip" data-bs-html="true" data-bs-placement="top" title="Die Sperrliste ist ein Verzeichnis von Ortskräften, denen der Zugang dauerhaft untersagt wurde.">
                            <i class="btn-icon-prepend mdi mdi-cancel"></i>
                            Sperrliste
                        </a>
                    `
          }
        },
        {
          search: {
            placeholder: 'Suchen'
          }
        }
      ],
    },
    "aLengthMenu": [
      [30, 50, 100, -1],
      [30, 50, 100, "Alle"]
    ],
    "iDisplayLength": 30,
    "language": {
      "search": "",
      "sEmptyTable": "Keine Ortkräfte vorhanden",
      "sInfo": "_START_ bis _END_ von _TOTAL_ Ortskräften",
      "sInfoEmpty": "Keine Ortkräfte vorhanden",
      "sInfoFiltered": "(gefiltert von _MAX_ Ortskräften)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ Einträge anzeigen",
      "sLoadingRecords": "Wird geladen...",
      "sProcessing": "Bitte warten...",
      "sSearch": "Suchen",
      "sZeroRecords": "Keine Ortkräfte vorhanden."
    },
    paginationType: 'simple_numbers'
  });

  $('#dataTableAccessCards').DataTable({
    "columnDefs": [
      { "width": "1%", "targets": 0 }
    ],
    stateSave: true,
    order: [[0, 'asc']],
    layout: {
      topEnd: {
        search: {
          placeholder: 'Suchen'
        }
      }
    },
    "aLengthMenu": [
      [30, 50, 100, -1],
      [30, 50, 100, "Alle"]
    ],
    "iDisplayLength": 30,
    "language": {
      "search": "",
      "sEmptyTable": "Keine Zutrittskarten vorhanden",
      "sInfo": "_START_ bis _END_ von _TOTAL_ Zutrittskarten",
      "sInfoEmpty": "Keine Zutrittskarten vorhanden",
      "sInfoFiltered": "(gefiltert von _MAX_ Zutrittskarten)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ Einträge anzeigen",
      "sLoadingRecords": "Wird geladen...",
      "sProcessing": "Bitte warten...",
      "sSearch": "Suchen",
      "sZeroRecords": "Keine Zutrittskarten vorhanden."
    },
    paginationType: 'simple_numbers'
  });

  $('#dTableLocalBlacklist').DataTable({
    stateSave: true,
    autoWidth: false, // Deaktiviert automatische Breitenanpassung für die gesamte Tabelle
    columnDefs: [
      {
        targets: -1, // Die Spalte, die angepasst werden soll (Index beginnt bei 0)
        width: '1px', // Minimale Breite (kann dynamisch angepasst werden)
        createdCell: function (td, cellData) {
          td.style.whiteSpace = 'nowrap'; // Verhindert Zeilenumbrüche
        }
      },
      {
        targets: -1, // Letzte Spalte
        orderable: false // Sortierbarkeit deaktivieren
      }
    ],
    order: [[0, 'asc']],
    layout: {
      topEnd: {
        search: {
          placeholder: 'Suchen'
        }
      }
    },
    "aLengthMenu": [
      [30, 50, 100, -1],
      [30, 50, 100, "Alle"]
    ],
    "iDisplayLength": 30,
    "language": {
      "search": "",
      "sEmptyTable": "Keine Einträge vorhanden",
      "sInfo": "_START_ bis _END_ von _TOTAL_ Personen",
      "sInfoEmpty": "Keine Einträge vorhanden",
      "sInfoFiltered": "(gefiltert von _MAX_ Personen)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ Einträge anzeigen",
      "sLoadingRecords": "Wird geladen...",
      "sProcessing": "Bitte warten...",
      "sSearch": "Suchen",
      "sZeroRecords": "Keine Personen vorhanden."
    },
    paginationType: 'simple_numbers'
  });

  $('#dTableAuthorizedIdentities').DataTable({
    stateSave: true,
    autoWidth: false, // Deaktiviert automatische Breitenanpassung für die gesamte Tabelle
    columnDefs: [
      {
        targets: -1, // Die Spalte, die angepasst werden soll (Index beginnt bei 0)
        width: '1px', // Minimale Breite (kann dynamisch angepasst werden)
        createdCell: function (td, cellData) {
          td.style.whiteSpace = 'nowrap'; // Verhindert Zeilenumbrüche
        }
      },
      {
        targets: 0, // Die Spalte, die angepasst werden soll (Index beginnt bei 0)
        width: '1px', // Minimale Breite (kann dynamisch angepasst werden)
        createdCell: function (td, cellData) {
          td.style.whiteSpace = 'nowrap'; // Verhindert Zeilenumbrüche
        }
      },
      {
        targets: -1, // Letzte Spalte
        orderable: false // Sortierbarkeit deaktivieren
      }
    ],
    order: [[0, 'asc']],
    layout: {
      topEnd: {
        search: {
          placeholder: 'Suchen'
        }
      }
    },
    "aLengthMenu": [
      [30, 50, 100, -1],
      [30, 50, 100, "Alle"]
    ],
    "iDisplayLength": 30,
    "language": {
      "search": "",
      "sEmptyTable": "Keine Einträge vorhanden",
      "sInfo": "_START_ bis _END_ von _TOTAL_ Personen",
      "sInfoEmpty": "Keine Einträge vorhanden",
      "sInfoFiltered": "(gefiltert von _MAX_ Personen)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ Einträge anzeigen",
      "sLoadingRecords": "Wird geladen...",
      "sProcessing": "Bitte warten...",
      "sSearch": "Suchen",
      "sZeroRecords": "Keine Personen vorhanden."
    },
    paginationType: 'simple_numbers'
  });

  $('#dTablePosMilitary').DataTable({
    stateSave: true,
    autoWidth: false, // Deaktiviert automatische Breitenanpassung für die gesamte Tabelle
    columnDefs: [
      {
        targets: -1, // Die Spalte, die angepasst werden soll (Index beginnt bei 0)
        width: '1px', // Minimale Breite (kann dynamisch angepasst werden)
        createdCell: function (td, cellData) {
          td.style.whiteSpace = 'nowrap'; // Verhindert Zeilenumbrüche
        }
      },
      {
        targets: 0, // Die Spalte, die angepasst werden soll (Index beginnt bei 0)
        width: '1px', // Minimale Breite (kann dynamisch angepasst werden)
        createdCell: function (td, cellData) {
          td.style.whiteSpace = 'nowrap'; // Verhindert Zeilenumbrüche
        }
      },
      {
        targets: -1, // Letzte Spalte
        orderable: false // Sortierbarkeit deaktivieren
      }
    ],
    order: [[0, 'asc']],
    layout: {
      topEnd: {
        search: {
          placeholder: 'Suchen'
        }
      }
    },
    "aLengthMenu": [
      [30, 50, 100, -1],
      [30, 50, 100, "Alle"]
    ],
    "iDisplayLength": 30,
    "language": {
      "search": "",
      "sEmptyTable": "Keine Militärischen Dienstposten vorhanden",
      "sInfo": "_START_ bis _END_ von _TOTAL_ Militärischen Dienstposten",
      "sInfoEmpty": "Keine Militärischen Dienstposten vorhanden",
      "sInfoFiltered": "(gefiltert von _MAX_ Militärischen Dienstposten)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ Einträge anzeigen",
      "sLoadingRecords": "Wird geladen...",
      "sProcessing": "Bitte warten...",
      "sSearch": "Suchen",
      "sZeroRecords": "Keine Militärischen Dienstposten vorhanden."
    },
    paginationType: 'simple_numbers'
  });

  $('#dTablePosCivil').DataTable({
    stateSave: true,
    autoWidth: false, // Deaktiviert automatische Breitenanpassung für die gesamte Tabelle
    columnDefs: [
      {
        targets: -1, // Die Spalte, die angepasst werden soll (Index beginnt bei 0)
        width: '1px', // Minimale Breite (kann dynamisch angepasst werden)
        createdCell: function (td, cellData) {
          td.style.whiteSpace = 'nowrap'; // Verhindert Zeilenumbrüche
        }
      },
      {
        targets: 0, // Die Spalte, die angepasst werden soll (Index beginnt bei 0)
        width: '1px', // Minimale Breite (kann dynamisch angepasst werden)
        createdCell: function (td, cellData) {
          td.style.whiteSpace = 'nowrap'; // Verhindert Zeilenumbrüche
        }
      },
      {
        targets: -1, // Letzte Spalte
        orderable: false // Sortierbarkeit deaktivieren
      }
    ],
    order: [[0, 'asc']],
    layout: {
      topEnd: {
        search: {
          placeholder: 'Suchen'
        }
      }
    },
    "aLengthMenu": [
      [30, 50, 100, -1],
      [30, 50, 100, "Alle"]
    ],
    "iDisplayLength": 30,
    "language": {
      "search": "",
      "sEmptyTable": "Keine Zivilen Dienstposten vorhanden",
      "sInfo": "_START_ bis _END_ von _TOTAL_ Zivilen Dienstposten",
      "sInfoEmpty": "Keine Zivilen Dienstposten vorhanden",
      "sInfoFiltered": "(gefiltert von _MAX_ Zivilen Dienstposten)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ Einträge anzeigen",
      "sLoadingRecords": "Wird geladen...",
      "sProcessing": "Bitte warten...",
      "sSearch": "Suchen",
      "sZeroRecords": "Keine Zivilen Dienstposten vorhanden."
    },
    paginationType: 'simple_numbers'
  });

  $('#dTablePosLocal').DataTable({
    stateSave: true,
    autoWidth: false, // Deaktiviert automatische Breitenanpassung für die gesamte Tabelle
    columnDefs: [
      {
        targets: -1, // Die Spalte, die angepasst werden soll (Index beginnt bei 0)
        width: '1px', // Minimale Breite (kann dynamisch angepasst werden)
        createdCell: function (td, cellData) {
          td.style.whiteSpace = 'nowrap'; // Verhindert Zeilenumbrüche
        }
      },
      {
        targets: 0, // Die Spalte, die angepasst werden soll (Index beginnt bei 0)
        width: '1px', // Minimale Breite (kann dynamisch angepasst werden)
        createdCell: function (td, cellData) {
          td.style.whiteSpace = 'nowrap'; // Verhindert Zeilenumbrüche
        }
      },
      {
        targets: -1, // Letzte Spalte
        orderable: false // Sortierbarkeit deaktivieren
      }
    ],
    order: [[0, 'asc']],
    layout: {
      topEnd: {
        search: {
          placeholder: 'Suchen'
        }
      }
    },
    "aLengthMenu": [
      [30, 50, 100, -1],
      [30, 50, 100, "Alle"]
    ],
    "iDisplayLength": 30,
    "language": {
      "search": "",
      "sEmptyTable": "Keine Ortskraft-Dienstposten vorhanden",
      "sInfo": "_START_ bis _END_ von _TOTAL_ Ortskraft-Dienstposten",
      "sInfoEmpty": "Keine Ortskraft-Dienstposten vorhanden",
      "sInfoFiltered": "(gefiltert von _MAX_ Ortskraft-Dienstposten)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ Einträge anzeigen",
      "sLoadingRecords": "Wird geladen...",
      "sProcessing": "Bitte warten...",
      "sSearch": "Suchen",
      "sZeroRecords": "Keine Ortskraft-Dienstposten vorhanden."
    },
    paginationType: 'simple_numbers'
  });

  $('#dTablePosGuests').DataTable({
    stateSave: true,
    autoWidth: false, // Deaktiviert automatische Breitenanpassung für die gesamte Tabelle
    columnDefs: [
      {
        targets: -1, // Die Spalte, die angepasst werden soll (Index beginnt bei 0)
        width: '1px', // Minimale Breite (kann dynamisch angepasst werden)
        createdCell: function (td, cellData) {
          td.style.whiteSpace = 'nowrap'; // Verhindert Zeilenumbrüche
        }
      },
      {
        targets: 0, // Die Spalte, die angepasst werden soll (Index beginnt bei 0)
        width: '1px', // Minimale Breite (kann dynamisch angepasst werden)
        createdCell: function (td, cellData) {
          td.style.whiteSpace = 'nowrap'; // Verhindert Zeilenumbrüche
        }
      },
      {
        targets: -1, // Letzte Spalte
        orderable: false // Sortierbarkeit deaktivieren
      }
    ],
    order: [[0, 'asc']],
    layout: {
      topEnd: {
        search: {
          placeholder: 'Suchen'
        }
      }
    },
    "aLengthMenu": [
      [30, 50, 100, -1],
      [30, 50, 100, "Alle"]
    ],
    "iDisplayLength": 30,
    "language": {
      "search": "",
      "sEmptyTable": "Keine Gäste-Dienstposten vorhanden",
      "sInfo": "_START_ bis _END_ von _TOTAL_ Gäste-Dienstposten",
      "sInfoEmpty": "Keine Gäste-Dienstposten vorhanden",
      "sInfoFiltered": "(gefiltert von _MAX_ Gäste-Dienstposten)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ Einträge anzeigen",
      "sLoadingRecords": "Wird geladen...",
      "sProcessing": "Bitte warten...",
      "sSearch": "Suchen",
      "sZeroRecords": "Keine Gäste-Dienstposten vorhanden."
    },
    paginationType: 'simple_numbers'
  });

})();